<?php
/*		Freewheeling Easy Mapping Application
 *		A collection of routines for display of trail maps and amenities
 *		copyright Roy R Weil 2024 - https://royweil.com
 *
 *  function fullNameFromShortName($subDire, $shortname)
*       converts a short name to a full path name
 *
 *  function SaveFile( subdirectory, filename, contents )
 *		save an internal or prebuilt file at $freewheeling_pagesPreBuiltUrl/...
 *  function getFileContents( subdirectory, filename, debug )
 *		reads an internal or  prebuilt file at $freewheeling_pagesPreBuiltUrl/...
*
 *  function freewheel_encapsulateWithCopyright( $html )
 *		Adds a copyright notice on the left and right of the HTML contents
 *			html - content to be encapsulated
 *
s *  freeWheeling_edit_setGlobals.map_setConstants
 *		Sets  several global constants, used throughout the code
 *      global $meters2Mile;
 *      global $freewheelingeasy_images_URL;
 *      global $freewheeling_prebuilt_dire, $freewheeling_pagesPreBuiltUrl;
 *      global $freewheelingeasy_kml_directory;
 *      global $eol, $errorBeg, $errorBeg, $errorEnd;
 *
 *  freeWheeling_edit_setGlobals.setGlobals("location called from") {
 *
 *
 */
class freewheeling_WriteUp
{
    public static function fullNameFromShortName($subDire, $shortname): string
    {
        global $eol, $errorBeg, $errorEnd;
        global $freewheeling_prebuilt_dire;
        global $freewheeling_prebuilt_dire_trails_html;
        global $freewheeling_prebuilt_dire_production;
        global $freewheeling_kmlStyles_directory;
        // $shortname is a short name of a file
        $debugFullNameFromShortName = rrwParam::isDebugMode("debugFullNameFromShortName");
        if ($debugFullNameFromShortName) print "I#677 subDire is $subDire, shortname is $shortname $eol
           &nbsp; &nbsp; &nbsp; freewheeling_prebuilt_dire_production is $freewheeling_prebuilt_dire_production $eol";
        if (empty($subDire)) {
            $iiSlash = strpos($shortname, "/");
            if ($iiSlash !== false) {
                $subDire = substr($shortname, 0, $iiSlash);
                $shortname = substr($shortname, $iiSlash + 1);
                if ($debugFullNameFromShortName) print "I#705 Updated to subDire is $subDire, shortname is $shortname $eol";
            }
        } // given a subdir, so use it
        $subDire = strToLower(rrwUtil::rrw_sanitize_file_name($subDire));
        switch ($subDire) {
            case strToLower("kmlStyles"):
                $finalDire = "$freewheeling_kmlStyles_directory";
                break;
            case strToLower("savedReports"):
                $finalDire = "/home/pillowan/www-shaw-weil-edit/wp-content/uploads/savedReports";
                break;
            case "trails-html":
            case "trails_html":
                $finalDire = $freewheeling_prebuilt_dire_trails_html;
                break;
            case "miles-by-type":
            case strToLower("trailHeads-html"):
            case "mileage-chart":
                $finalDire = "$freewheeling_prebuilt_dire_production/$subDire";
                break;
            case "kml":
                $finalDire = "/home/pillowan/www-shaw-weil-edit/wp-content/uploads/kml";
                break;
            default:
                $finalDire = "$freewheeling_prebuilt_dire/$subDire";
                break;
        }
        if ($debugFullNameFromShortName) print "I#  finalDire is '$finalDire' $eol";
        if (!is_dir($finalDire)) {
            if ($debugFullNameFromShortName) print "I# '$finalDire' is not a directory $eol";
            $errmsg = "$errorBeg E#758 in fullNameFromShortName($subDire,$shortname)  final Dire '$finalDire' is not a directory
                                are the global variables set?
                                in particular freewheeling_prebuilt_dire_production= '$freewheeling_prebuilt_dire_production' $errorEnd";
            $errmsg .= rrwFormat::backtrace($errmsg, 3);
            throw new Exception($errmsg);
        }
        $finalFile = "$finalDire/" . rrwUtil::rrw_sanitize_file_name($shortname);
        if ($debugFullNameFromShortName) print "I# final file is '$finalFile'  $eol" . rrwFormat::backtrace("", 4);
        return $finalFile;
    }
    /**
     * Retrieves the contents of a file from a specified subdirectory.
     *
     * This method attempts to read the contents of a file located in a given subdirectory.
     * If the subdirectory is empty it will search most  of prebuilt for the file.
     * if not logged in will remove the editViewStart to editViewEnd section
     *
     * @param string $subDire The subdirectory under 'prebuilt' where the file is located.
     * @param string $filename The name of the file to retrieve.
     * @param bool $debug Optional. If true, enables debugging output. Default is false.
     * @return string The contents of the file or an error message if the file is not found.
     * @throws Exception If the subdirectory or filename is empty.
     */
    public static function getFileContents($subDire, $filename,  $debug = false)
    {
        // returns the contents of the file in the specified subdirectory under prebuilt
        global $eol, $errorBeg, $errorEnd;
        global $freewheeling_prebuilt_dire;
        $msg = "";
        $msg .= freeWheeling_edit_setGlobals::setGlobals("getFileContents");
        static $countLoops = 0;    // this code is to prevent infinite loops
        $countLoops++;
        $debugGetContents = rrwParam::isDebugMode("debugGetContents");
        if ($debug) $debugGetContents = true;
        if ($countLoops > 10)
            $debugGetContents = true;
        if ($countLoops > 15) {
            $msg .= "$errorBeg E#762  too many loops thought getFileContents $errorEnd";
            return $msg;
        }
        $msg .= freeWheeling_edit_setGlobals::setGlobals("getFileContents");
        if ($debugGetContents) {
            $msg .= "I#763 subDire is $subDire, filename is $filename $eol";
            if (empty($filename)) {
                throw new Exception("$errorBeg E#2306 filename is empty $errorEnd");
            }
        }
        $finalFile = self::fullNameFromShortName($subDire, $filename);
        if (file_exists($finalFile)) {
            if ($debugGetContents) print "file $finalFile exists, we are good $eol";
            $msg .= self::returnFileContents($finalFile);
            $countLoops = 0;    // success, so reset the loop counter
            return $msg;
        } // end if file exists
        if (!empty($subDire)) {
            $msg .= self::returnFileContents($finalFile);
            $countLoops = 0;    // success, so reset the loop counter
            return $msg;
        } // end if not empty subDire
        $lookups = "<!-- looking for file '$filename' in subdirectory '$subDire' -->$eol";
        // subDire was blank, so go look for file
        $path_parts = pathinfo($filename);    //  strip the input name to just the file name
        $basename =  $path_parts['filename'];
        foreach (
            array(
                "data",
                "amenities",
                "trails-html",
                "miles-by-type",
                "kmlStyles",
                "trailheads-html",
                "miles-by-type",
                "mileage-chart",
                "savedReports"
            ) as $testDire
        ) {
            $dire2Check = self::fullNameFromShortName($testDire, "");
            if ($debugGetContents) $msg .= "looking in $dire2Check  $eol";
            foreach (array(".php", ".html", ".htm", ".txt", ".json", "") as $ext) {
                $fileNameFull = $dire2Check . "$basename$ext";
                if (file_exists($fileNameFull)) {
                    if ($debugGetContents) $msg .= "$lookups E#458 found file '$fileNameFull' -->\n";
                    $msg .= self::returnFileContents($fileNameFull);
                    $countLoops = 0;    // success, so reset the loop counter
                    return $msg;
                } // end if file exists
                if ($debugGetContents) $msg .= "<-- $lookups E#768 did not find file '$fileNameFull' -->\n";
            } // end foreach (array("php", "html") as $ext
        } // end foreach (array("data", "amenities") as $dire
        $msg .= "$errorBeg E#761  did not find file '$filename' in any subdirectory $errorEnd";
        return $msg;
    }
    /**
     * Returns the contents of the specified file.
     * if not logged in will remove the editViewStart to editViewEnd section
     *
     * @param string $filenameFull The full path to the file.
     * @param bool $debug Optional. If true, enables debugging output. Default is false.
     * @return string The contents of the file.
     * @throws Exception If the file does not exist or cannot be read.
     */
    private static function returnFileContents($filenameFull, $debug = false)
    {
        // returns the contents of the file in the specified subdirectory under prebuilt
        // or return an exception if the file is not found"
        global $eol, $errorBeg, $errorEnd;
        $debugGetContents = rrwParam::boolean("debugGetContents");
        if ($debug) $debugGetContents = true;
        // need more code to deal with ,json files
        $finalFile = rrwUtil::rrw_sanitize_file_name($filenameFull);
        if (!file_exists($finalFile)) {
            $iiSlash = strrpos($finalFile, "/") + 1;
            $finalFile = substr($finalFile, $iiSlash);
            $msgErr = "$errorBeg E#2313  did not find file ' $finalFile' $eol
                        please copy this message and use the
                        <a href='/webmaster-feedback' target='feedback' > feedback form to report this problem$errorEnd";
            $msgErr1 = $finalFile . rrwFormat::backtrace($msgErr, 4);
            throw new Exception($msgErr);
        }
        //  print "$eol<-- I#796 do a fopen of $finalFile -->$eol";
        $fp = fopen("$finalFile", "r");
        if (!is_resource($fp)) {
            $errmsg = "$errorBeg E#759  $finalFile  is not a resource $errorEnd";
            $errmsg1 = rrwFormat::backtrace($errmsg);
            throw new Exception($errmsg1);
        }
        $numBytes = filesize($finalFile);
        if ($numBytes === false) {
            $errmsg = "$errorBeg E#760 $finalFile  is not a resource $errorEnd";
            $errmsg1 = rrwFormat::backtrace($errmsg);
            throw new Exception($errmsg1);
        }
        if ($debugGetContents) print  "file $finalFile  has numBytes is $numBytes $eol";
        if ("json" == pathinfo($finalFile, PATHINFO_EXTENSION))
            $fileContents =  "<pre>\n " . fread($fp, $numBytes) . "</pre>$eol";
        else
            $fileContents = fread($fp, $numBytes);
        fclose($fp);
        if (is_user_logged_in() === false) {
            // print "I#335 not logged in so remove the editViewStart to editViewEnd section $eol";
            $cntInfiniteDetect = 0;
            while (strpos($fileContents, freeWheel::editViewStart) !== false) {
                $cntInfiniteDetect++;
                if ($cntInfiniteDetect > 1200) {
                    $errmsg2 = "$errorBeg E#684  infinite loop looking for editViewStart in file $finalFile $errorEnd";
                    throw new Exception($errmsg2);
                }
                $iiStart = strpos($fileContents, freeWheel::editViewStart);
                $iiEnd = strpos($fileContents, freeWheel::editViewEnd);
                $fileContents = substr($fileContents, 0, $iiStart) . substr($fileContents, $iiEnd + strlen(freeWheel::editViewEnd));
            } // end while editViewStart
        }
        return $fileContents;
    } // end function returnFileContents($filenameFull, $debug = false)
    /**
     * Saves a file with comparison to its previous contents.
     *
     * This function compares the new contents with the existing contents of the file.
     * If there is a change, it saves the new contents to the file and returns a message indicating the update status.
     *
     * @param string $subdirectory The subdirectory where the file is located.
     * @param string $fileName The name of the file to be saved.
     * @param string $contents The new contents to be saved to the file.
     * @param string $displayType The type of display for the status message (default is "file").
     * @return string A message indicating the status of the file save operation.
     */
    public static function saveFileWithCompare($subdirectory, $fileName, $contents, $displayType = "file")
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $filenameFull = self::fullNameFromShortName($subdirectory, $fileName);
        if (file_exists($filenameFull))
            $oldContents = file_get_contents($filenameFull);
        else
            $oldContents = "";
        $tempNew = substr($contents, 0, 800);
        if (strpos($tempNew, "freewheeling-points") !== false) {
            // need to discard the first few characters because of the date
            $startOld = strpos($oldContents, "body>") + 50;
            $startNew = strpos($contents, "body>") + 50;
        } else {
            $startOld = 0;
            $startNew = 0;
        }
        if (substr($oldContents, $startOld) == substr($contents, $startNew))
            $status = " no change? ";
        else {
            $msg .= self::saveFile($subdirectory, $fileName,  $contents);
            $status = "<span style='backgroundColor:DarkSalmon;'>updated</span>";
        }
        $msg .= "I#508 $subdirectory/$fileName <a href='/write-up?$displayType=$subdirectory/$fileName' target='datafile'>$status</a>$eol";
        return $msg;
    }
    public static function saveReport($type,  &$contents, $extension = "txt")
    {
        $filename = $type . "_" . date('Y-m-d--H:i:s:u') . ".$extension";
        $msg = self::saveFile("savedReports", $filename, $contents);
        return $msg;
    }
    public static function saveFile($subDire, $filename, &$contents)
    {
        // save the file in the specified subdirectory under prebuilt
        // note an empty subDirectory will fail in the fullNameFromShortName routine
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $msg .= freeWheeling_edit_setGlobals::setGlobals("saveFile");
        $finalFileName = self::fullNameFromShortName($subDire, $filename);
        //$msg .= "finalFileName is $finalFileName $eol";
        $fp = fopen($finalFileName, "w");
        if (!is_resource($fp)) {
            $errmsg = "$errorBeg E#767  $finalFileName is not a resource $errorEnd";
            $msg .= $errmsg;
            $msg .= rrwFormat::backtrace($errmsg, 2);
            throw new Exception($errmsg);
        }
        $numBytes = fwrite($fp, $contents);
        if ($numBytes === false) {
            $errmsg = "$errorBeg E#2318  $finalFileName fwrite failed $errorEnd";
            $msg .= $errmsg;
            $msg .= rrwFormat::backtrace($errmsg);
            throw new Exception($errmsg);
        }
        return $msg;
    }
    public static function saveMsg2Files($filename, $contents)
    {   // called at the end of a run that does major google cost operations.
        // save the file, typically content is the $msg from the run
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $msg .= "Copy of run to be saved at
        <a href='/write-up/?file=$filename' target='history'>$filename</a> $eol";
        $msg .= self::saveReport("googleUpdate_", $contents, "html");
        return $msg;
    }
    /**
     * Cleans out old saved report files from the "savedReports" directory.
     *
     * This static method iterates through all files in the saved reports directory and deletes
     * those that are older than 3 hours.      *
     * @return string Log messages about deleted or kept files.
     */
    public static function cleanOldSavedReports()
    {
        // clean out files older than a 3 hours from the savedReports directory
        // Ensure we get a valid directory path for DirectoryIterator
        $dire2Clean = dirname(self::fullNameFromShortName("savedReports", "dummy.txt"));
        $msg = rrwUtil::cleanUpOldLogs($dire2Clean, "000.txt", 3);
        return $msg;
    }
    public static function formatDataTxtFileName($middle)
    {
        //Take a file
        global $eol, $errorBeg, $errorEnd;
        $debugFormatDataTxt = false;
        if (strpos($middle, "/") === false)
            $middle = "data/$middle"; // if no slash it must be a data file
        if (strpos($middle, ".") === false)
            $middle = "$middle.txt";    // if no dot it must be a .txt file
        $middle = str_replace("//", "/", $middle);
        $middle = str_replace(" ", "-", $middle);
        $middle = rrwUtil::rrw_sanitize_file_name($middle);
        // rrw_sanitize_file_name removes stuff, changes space to minus
        if ($debugFormatDataTxt) print "$middle $eol ";
        return $middle;
    }   // end function formatDataTxtFileName($middle)
    public static function freewheelingWriteUpDisplay($attributeArray)
    {
        // called from the short_code on a webpage.
        // bookName and trailId result in the same file display.  pages from the book.
        // amenity results in the display of
        // all files are displayed/written using the
        //        FreeWheeling_WriteUp::getFileContents, saveFile function
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        try {
            $debugParameters = rrwParam::isDebugMode("debugParameters");
            $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheelingWriteUpDisplay setup");
            if ($debugParameters) $msg .= rrwUtil::print_r($attributeArray, true, "I#757 calling parameters");
            $amenity = rrwParam::String("amenity", $attributeArray);
            $bookName = rrwParam::String("bookName", $attributeArray);
            $kml = rrwParam::String("kml", $attributeArray);
            $target = rrwParam::String("target", $attributeArray);
            $fileNameShort = rrwParam::String("file", $attributeArray);
            $filePoints = rrwParam::String("pointFile", $attributeArray);
            if ($debugParameters) $msg .= "bookName is $bookName, amenity is $amenity, fileNameShort is $fileNameShort
                kml = $kml, target = $target, filePoints = $filePoints $eol";
            $back_color = get_option("freewheelingeasy_menu_footer_background_color");
            if (empty($back_color))
                $back_color = "Light Purple Blue"; // dark blue
            // now to set fileNameFull based on input parameters
            //  note test for trail id last, because it is the most likely to be set via cookie
            if (!empty($amenity)) {
                if ($debugParameters) $msg .= "getFileContents(amenities, $amenity.html $eol";
                $msg .= freewheeling_WriteUp::getFileContents("amenities", "$amenity.html");
            } elseif (!empty($bookName)) {  // a few pages from the book
                $msg .= rrwFormat::sellTheBook();   // one Line to sell the book
                $msg .= freewheeling_WriteUp::getFileContents("trails_html", "$bookName.html");
            } elseif (!empty($kml)) {  // a few pages from the book
                $msg .= freewheeling_WriteUp::getFileContents("kml", "$kml");
            } elseif (!empty($fileNameShort)) {
                $msg .= freewheeling_WriteUp::getFileContents("", $fileNameShort); // get determines subdirectory
            } elseif (!empty($filePoints)) {
                $msg .= self::printPointFile($filePoints); //
            } else {
                /*   $msg .= "A display of some page content was asked for, but no parameters were given $eol"
                    . "try adding a parameter of &bookName, &amenity, &file, &kml, &target, &filePoints $eol"
                    . "or return to the <a href='/' >home page<a>  $eol";
            */
                $msg .= DisplayHomePage();
            }
            $noHead = rrwParam::boolean("noHead", $attributeArray);
            if ($noHead) {
                $msg .= "
                <script>
var titleThing = document.getElementsByClassName('entry-title');
for (i = 0; i < titleThing.length; i++) {
  titleThing[i].innerHTML  = '';
}
</script>";
            }
        } catch (Exception $e) {
            $msg .= $e->getMessage() . " E#764 bottom of the freewheelingWriteUpDisplay look elsewhere for error $eol";
        }
        return $msg;
    } // end function freewheelingWriteUpDisplay( $attributeArray )
    private static function printPointFile($fileNameShort)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $debugPointFile = false;
        $content = freewheeling_WriteUp::getFileContents("", $fileNameShort); // get determines subdirectory
        if (empty($content)) {
            $msg .= "E#2311 the input $fileNameShort is empty ";
            return $msg;
        }
        $iiBody = strpos("<body)", $content);
        $content = substr($content, $iiBody);
        if (strlen($content) < 50)
            throw new Exception("E#2312 the input $fileNameShort is less than 59 characters ");
        $iiTitle1 = strpos($content, "<title") + 7;
        $iiTitle2 = strpos($content, "</title");
        $title = substr($content, $iiTitle1, $iiTitle2 - $iiTitle1);
        $iiBody = strpos($content, "<body");
        $content = substr($content, $iiBody + 6);
        $data = explode("|", $content);
        if ($debugPointFile) {
            $msg .= "there are " . count($data) . " items in file '$fileNameShort' $eol";
            $msg .= str_repeat("VV", 80) . $eol . htmlspecialchars(substr($content, 0, 7000), ENT_QUOTES) . str_repeat("^^", 80) . $eol;
        }
        $itemCnt = 0; // number of items per line in the file
        $msg .= "<h1>$title</h1>";
        $msg .= "<table class='milepostTable' style='background-color:lightblue;'><tr>";
        for ($iiFirst = 0; $iiFirst < 20; $iiFirst++) {
            if ($data[$iiFirst] == "x") {
                $itemCnt = $iiFirst;
                break;
            } // end if found the x
            $msg .= rrwFormat::CellHeader($data[$iiFirst]);
        }  // end for iiFirst
        $msg .= "</tr>";
        if (0 == $itemCnt)
            throw new Exception("E R R O R  E#2316 did not find an x in " + $title);
        for ($ii = $itemCnt + 1; $ii < count($data) - 1; $ii = $ii + $itemCnt) {
            $msg .= "<tr>";
            for ($jj = 0; $jj < $itemCnt; $jj++) {
                $msg .= rrwFormat::Cell($data[$ii + $jj]);
            }
            $msg .= "</tr>";
        }
        $msg .= "</table>";
        return $msg;
    } // end function printPointFile($fileNameShort)
} // end class freewheeling_WriteUp
function DisplayHomePage()
{
    global $eol, $errorBeg, $errorEnd;
    $msg = "";
    try {
        $msg .=  "\n<!-- no file name to display, so display the default page -->\n";
        $msg .=  '
            <div id="main" class="site-main">
	            <div id="primary" class="content-area">
		            <div id="content" class="site-content" role="main">
					    <div class="entry-content">
<div class="wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile" style="grid-template-columns:auto 33%"><figure class="wp-block-media-text__media"><img decoding="async" fetchpriority="high" width="861" height="1024" src="https://freewheelingeasy.com/wp-content/uploads/2018/11/frontcover-861x1024.png" alt="Front Cover of FreeWheeling Easy" class="wp-image-146"/></figure>
<div class="wp-block-media-text__content">
<header class="entry-header">
						<span class="entry-title">Trails for the Rest of Us</span>
					</header><!-- .entry-header -->
<p>If you like to bicycle but you don&quot;t like to ride in automobile traffic or on rough, steep,
undeveloped tracks, these trails are for you. They are: easy to ride or walk, off-limits to
automobile traffic, reasonably level. If you have ridden the same trails over and over again
and are looking for new trails to ride then this book is for you.
</p>
<p>After a long hiatus, a portion of&nbsp;<em>FreeWheeling Easy</em>&nbsp;returns to print with
fresh information on the enormous trail progress over the past several years.&nbsp;
Because of the substantial growth, we are issuing the book in several parts. This first part, at
240 pages, is almost two and a half times the size of the original edition (1995) which covered
the entire region!.
</p>
<p>The Oct 2018 volume NE covers the collection of trails that are Northeast of Pittsburgh. These
are the trails that are in the Allegheny and Kiskamenikas River basins, including the Erie to Pittsburgh Trail.
</p>
<p>As always with a print edition about trails, which are constantly being developed, there may be
some information that is out of date or incorrect. Trail builders just keep building trails.
This web site will have the&nbsp;<a href="/current-draft/">latest draft of the Gui</a>de.
It is&nbsp;a <strong>draft</strong>&nbsp;so the image resolution is not great. If you see
some incorrect or know of additional information, feel free to use&nbsp;<a href="/webmaster-feedback/">
the feedback form</a>.
</p>
<p class="has-medium-font-size">  <br><a href="/order-the-book/">Order the book from the Authors</a>
or <br><a href="/support-your-local-bike-shop/">Support your local bike shop</a>
or <br><a href="https://www.amazon.com/gp/product/097273242X/&amp;tag=shawweil-0922">Order from
Amazon.com</a>
</p>
</div> <!-- wp-block-media-text__content -->
</div> <!-- wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile -->
            </div><!-- .entry-content -->
		</div><!-- #content -->
	</div><!-- #primary -->
</div>  <!-- #main -->
';
        return $msg;
        // end else no file name to display, so display the default page
    } catch (Exception $e) {
        $msg .= $e->getMessage() . $eol;
        return $msg;
    } // end catch
}
function freewheel_encapsulateWithCopyright($html)
{
    global $freewheeling_pagesPreBuiltUrl;
    $msg = "";
    $msg .= freeWheeling_edit_setGlobals::setGlobals("freewheel_encapsulateWithCopyright ");
    $temp = "
<table>
    <tr>
        <td class='rrw_trail_copyrightOnSides'>
            <img src='$freewheeling_pagesPreBuiltUrl/images/left%20margin.jpg'
                alt='copyright &copy;2019 Shaw-Weil associates' />
        </td>
        <td>
            $html
        </td>
        <td class='rrw_trail_copyrightOnSides'>
            <img src='$freewheeling_pagesPreBuiltUrl/images/left%20margin.jpg'
                alt='copyright &copy;2019 Shaw-Weil associates' />
        </td>
    </tr>
</table>";
    return $temp;
} // end freewheel_encapsulateWithCopyright ($html)