function buildupPanorama (marker) {
    //
    myLatLng = marker.getPosition();
    dinoName = marker.dinoName;
    fileName = marker.trailId;
    trailId = marker.trailId;
    pano = marker.pano;
    console.log("buildupPanorama #9 called for dino " + marker.dinoName + ", pano " + marker.pano + ", fileName "
        + marker.trailId + ", trailId " + marker.trailId + ", " + fileName);
    marker.addListener('mouseover', function () {
        console.log("mouseover #10 for " + this.dinoName + ", pano " + this.pano + ", fileName " + this.trailId) + ", trailId " + this.trailId;
        infoWindowsOpen.forEach(closeinfo);
        const pano2 = this.pano.split(",");
        if (this.pano.substring(0, 2) == "MP" || pano2.length < 5) {
            //alert("Dino milepost  " + this.pano + " is MP, or no streetView numbers using default");
            heading3 = 34;
            pitch3 = 10;
            lat3 = this.position.lat().toFixed(7);
            lng3 = this.position.lng().toFixed(7);
            zoom3 = 16;
        } else {
            const pano2 = this.pano.split(",");
            //alert("Dino pano " + this.pano + " splits " + pano2[0] + ", " + pano2[1] + ", " + pano2[2] + ", " + pano2[3] + ", " + pano2[4]);
            heading3 = parseInt(pano2[0]);
            pitch3 = parseInt(pano2[1]);
            lat3 = pano2[2];
            lng3 = pano2[3];
            zoom2 = pano2[4];
            zoom2 = zoom2.trim();
            zoom2 = zoom2.split(" ");
            zoom3 = parseInt(zoom2[0]);
            const urlParams = new URLSearchParams(window.location.search);
            var fileName = urlParams.get('fileName');
        }
        console.log("dino #9 buildupPanorama " + heading3 + ", pitch " + pitch3 + ", lat " + lat3 + ", lng " + lng3 + ", zoom = " + zoom3 + ", name " + this.dinoName + ", trailId " + this.trailId + ", fileName " + fileName);
        contentString = "<span style = 'font-weight:bold; font-size:large;' > " + this.dinoName
            + "</span> [ <a href='https://dinomitedays.org/designs/"
            + this.trailId + ".htm' > details</a> ] "
            + "<a href='https://www.google.com/maps/dir//"
            + lat3 + "," + this.position.lng() + "/@"
            + lat3 + "," + lng3
            + ",17z/data=!4m2!4m1!3e0' > "
            + " <img src='https://freewheelingeasy.com/prebuilt/images/directions%2040X40.png' width='20' height='auto' "
            + "/> </a> ] ";
        // has latitude or could not place it
        if (lat3 != 0) {
            contentString += "[ <a href='https://dinomitedays.org/wp-content/plugins/freewheeling-map/pano/panorama.php?&amp;fileName=" + this.trailId
                + "&amp;lat=" + lat3 + "&amp;lng=" + lng3 + "&amp;zoom=" + zoom3
                + "&amp;heading=" + heading3 + "&pitch=" + pitch3 + "'&amp;nohead=1'"
                + " ><img src='https://freewheelingeasy.com/prebuilt/icon-google/pegman 33 x 51.jpg' width='20px' "
                + "/> </a> ]  ";
        }
        contentString += "<br><a href='/designs/" + this.trailId + ".htm' > <img src='https://dinomitedays.org/designs/images/" + this.trailId + ".jpg' height='300' /></a>";
        // alert("contentString " + contentString);
        var info = new google.maps.InfoWindow({
            content: contentString,
            position: this.position
        });
        info.open(mapScreen, this);
        infoWindowsOpen.push(info); // save it away for close
        setTimeout(function () { infoWindowsOpen.forEach(closeinfo); }, '4500');
    }); // end  mouseover function
    marker.addListener('click', function () {
        url = "/designs/" + this.trailId + ".htm";
        window.open(url, "mapIt");
    }); // end click
    marker.setDraggable(true);
    // Add a listener for the 'dragend' event
    marker.addListener('dragend', function () {
        var positionEnd = this.getPosition();
        var latitude = positionEnd.lat().toFixed(7);
        var longitude = positionEnd.lng().toFixed(7);
        table = "pillowan_wpprrj_00rrwdinos";;
        var sql = "update " + table + " set latitude = " + latitude
            + ", longitude = " + longitude
            + " where fileName = '" + this.trailId + "';";
        console.log(sql);
        //           alert("dragend " + latitude + ", " + longitude + ", " + sql);
    }); // end dragend
} // end function buildupPanorama