function initialize () {
    const urlParams = new URLSearchParams(window.location.search);
    console.log("url string:" + urlParams.toString());
    var lat2 = urlParams.get('lat');
    var lng2 = urlParams.get('lng');
    var head2 = urlParams.get('heading');
    var pitch2 = urlParams.get('pitch');
    var zoom2 = urlParams.get('zoom');
    var fileName = urlParams.get('fileName');
    console.log("#2 param: " + lat2 + " Longitude param: " + lng2);
    console.log("#2 param: " + head2 + " Pitch param: " + pitch2);
    var lat3 = parseFloat(lat2);
    var lng3 = parseFloat(lng2);
    var head3 = parseInt(head2);
    var pitch3 = parseInt(pitch2);
    var zoom3 = parseInt(zoom2);
    console.log("#9 lat3,lat3, head3, pitch3, zoom3 fileName: " + lat3 + ", " + lng3 + ", " + head3 + ", " + pitch3 + ", " + zoom3 + ", " + fileName);
    if (lat2 == 0 || lat2 == "" || isNaN(lat2)) {
        document.getElementById("panoramaGoogleMap").innerHTML = "<div style='font-size:large; font-weight:bold; color:red;'>No StreetView data for this dinosaur</div>";
        return;
    }
    /* fen way stuff from initial sample
        var lat3 = 42.345573;
        var lng3 = -71.098326;
        var head3 = 34;
        var pitch3 = 20;
    console.log("#9 param: " + head3 + " Pitch param: " + pitch3);
    console.log("#9: " + lat3 + " Longitude: " + lng3);
    var lat1 = 42.345573;
    var lon1 = -71.098326;
    console.log("Latitude: " + lat1 + " Longitude: " + lon1);
    */
    var centerLatLon = { lat: lat3, lng: lng3 };
    var map = new google.maps.Map(document.getElementById("panoramaGoogleMap"), {
        center: centerLatLon,
        zoom: 14,
    });
    var url = "";
    var panorama = new google.maps.StreetViewPanorama(document.getElementById("panoramaWindow"),
        {
            position: centerLatLon,
            pov: {
                heading: head3,
                pitch: pitch3,
                zoom: 14,
            },
        },
        onclick = function () {
            console.log("panorama.js onclick called #9");
            const urlParams = new URLSearchParams(window.location.search);
            var fileName = urlParams.get('fileName');
            var myDiv = document.getElementById("panoramaWindow");
            //alert("myDiv is " + myDiv);
            var head = panorama.pov.heading.toFixed(0);
            var pitch = panorama.pov.pitch.toFixed(0);
            var lat = panorama.position.lat().toFixed(7);
            var lng = panorama.position.lng().toFixed(7);
            //    var dinoName = panorama.dinoName;
            var dinoName = panorama.dinoName;
            var trailId = panorama.trailId;
            console.log(" Panorama click at heading " + head + ", pitch " + pitch
                + ", lat " + lat + ", lng " + lng);
            console.log(" File Name: " + fileName + ", Dino Name: " + dinoName + ", Trail ID: " + trailId);
            var url = 'https://dinomitedays.org/panarama-update/?fileName=' + fileName + '&heading=' + head
                + '&zoom=' + map.getZoom() + '&pitch=' + pitch + '&lat=' + lat + '&lng=' + lng;
            console.log(" ");
            console.log(url);
            console.log(" ");
            /*
             fetch(url)
               .then(res => res.text())
               .then(html => {
                 //console.log('Page HTML:', html);
               })
               .catch(err => console.error('Fetch error:', err));
               */
            //alert(" onclick done")
        }
    );
    map.setStreetView(panorama);
} // end function initialize
console.log("panorama/panorama.js loaded #9 ");
window.initialize = initialize;
console.log("assigned window.initialize");