<?php

class panoramaUpdate
{
    public function __construct()
    {
        /* do nothing */
    }

    public static function  updateStreetViewList($attributes)
    {
        global $wpdbExtra;
        global $eol;
        $msg = "updateStreetViewList routine $eol";;
        // quick check to see of we should destroy the StreetViewList list for this file
        $lat = rrwParam::number('lat', $attributes);
        $msg .= "lat = $lat $eol";
        if ($lat == 0) {
            $StreetViewList = "";
        } else {
            // note: the order of the viewParams is important as it is used to split the string in the panorama.js file
            $viewParams = array(
                'heading' => rrwParam::String('heading', $attributes),
                'pitch' => rrwParam::String('pitch', $attributes),
                'lat' => rrwParam::String('lat', $attributes),
                'lng' => rrwParam::String('lng', $attributes),
                'zoom' => rrwParam::String('zoom', $attributes),
            );
            $StreetViewList = implode(",", $viewParams);
        }
        $fileName = rrwParam::String('fileName', $attributes);

        $sqlUpdate = "UPDATE $wpdbExtra->dinosaurs  SET `StreetViewList` = '$StreetViewList' WHERE `fileName` = '$fileName'";
        $msg .= "UPDATE $wpdbExtra->dinosaurs  SET `StreetViewList` = '$StreetViewList' WHERE `fileName` = '$fileName' $eol";
        $cnt = $wpdbExtra->query($sqlUpdate);

        $msg .= "update $cnt panoramic view parameters $eol$eol";
        $url  = "https://edit.shaw-weil.com/make-dino-map-files/?allowed=1";

        $msg .= rrwUtil::fetchUrlContents($url);

        return $msg;
    }

    public static function streetViewMissing($attribute)
    {
        global $wpdbExtra;
        $msg = "";
        $sqlExisting = "SELECT dinoName, fileName, latitude, longitude, mapLoc, streetViewList FROM $wpdbExtra->dinosaurs
                    WHERE not (`StreetViewList` IS NULL OR `StreetViewList` = '')
                    and latitude > 0 and longitude < 0
                    order by DinoName";
        //
        $sqlMissing = str_replace("not", "", $sqlExisting);
        $msg .= self::ShowList("The following Panoramas  are missing:", $sqlMissing);
        $msg .= self::ShowList("we have Panorama for the following:", $sqlExisting);
        return $msg;
    } // end of function streetViewMissing

    private static function ShowList($title, $sql)
    {
        global $wpdbExtra;
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $msg .= "SQL: $sql $eol";
        $msg .= "<h1>$title</h1>" . $eol;;
        $results = $wpdbExtra->get_resultsA($sql);
        foreach ($results as $row) {
            $filename = $row["fileName"];
            $dinoName = $row["dinoName"];
            $mapLoc = $row["mapLoc"];
            $msg .= "<img src='https://dinomitedays.org/designs/images/$filename.jpg' style='max-width:300px;' /></a>\n";
            $msg .= self::getStreetViewUrl($row);
            $msg .= "$dinoName -- &nbsp; $mapLoc<br />";
        } // end of foreach dino row
        return $msg;
    } // end of function ShowList

    public static function getStreetViewUrl($row)
    {
        global $eol, $errorBeg, $errorEnd;
        $msg = "";
        $streetViewList = $row["streetViewList"];
        $dinoName = $row["dinoName"];
        $fileName = $row["fileName"];
        if (empty($streetViewList) || strlen($streetViewList) < 5) {
            $heading3 = 0;   // north
            $pitch3 = 10;
            $zoom3 = 14;
            $lat3 = $row["latitude"];
            $lng3 = $row["longitude"];
            $urlText = " no panorama available ";
            if (empty($lat3) || empty($lng3)) {
                $url = "<a href='' > Missing lat/lng for $dinoName \n";
                return $url;
            }
        } else {
            list($heading3, $pitch3, $lat3, $lng3, $zoom3) = explode(",", $streetViewList);
            $urlText = "";
        }
        $url = "<a href='https://dinomitedays.org/wp-content/plugins/freewheeling-map/pano/panorama.php?&amp;dinoName=$dinoName&amp;fileName=$fileName
				&amp;lat=$lat3&amp;lng=$lng3&amp;zoom=$zoom3
			    &amp;heading=$heading3&amp;pitch=$pitch3&amp;nohead=1' target='panorama'>\n
				<img src='https://freewheelingeasy.com/prebuilt/icon-google/pegman 33 x 51.jpg' width='20px' >$urlText</a>\n";
        return $url;
    } // end of function getStreetViewUrl

} //
//
//
add_shortcode('freewheeling-easy-map-panorama-update', array('PanoramaUpdate', 'updateStreetViewList'));
add_shortcode('freewheeling-easy-map-panorama-missing', array('PanoramaUpdate', 'streetViewMissing'));
